#!/usr/bin/env python

# ...

from distutils.core import setup

setup(name='pycryptodome-qpython3',
      version='3.8.1',
      description='Cryptographic library for QPython',
      author="Helder Eijs",
      author_email="helderijs@gmail.com",
      url='https://www.pycryptodome.org',
      packages=["Crypto", "Crypto.PublicKey", "Crypto.Util", "Crypto.Signature", "Crypto.Hash", "Crypto.IO", "Crypto.SelfTest", "Crypto.SelfTest.PublicKey", "Crypto.SelfTest.Util", "Crypto.SelfTest.Signature", "Crypto.SelfTest.Hash", "Crypto.SelfTest.IO", "Crypto.SelfTest.Cipher", "Crypto.SelfTest.Protocol", "Crypto.SelfTest.Math", "Crypto.SelfTest.Random", "Crypto.Cipher", "Crypto.Protocol", "Crypto.Math", "Crypto.Random"],
      package_data={
            "Crypto":[ "*.py","*.so", ],
            "Crypto.Math": [ "*.so" ],
            "Crypto.Protocol": [ "*.so" ],
            "Crypto.Cipher": [ "*.so" ],
            "Crypto.Hash": [ "*.so" ],
            "Crypto.Util": [ "*.so" ],
            "Crypto.PublicKey": [ "*.so" ],
      },
      long_description="""
PyCryptodome is a self-contained Python package of low-level
cryptographic primitives.
""",
      license="BSD"
     )
