import os
import sys

from .context import get_context

LOKY_PICKLER = os.environ.get("LOKY_PICKLER")

if sys.version_info > (3, 4):

    def _make_name():
        name = '/loky-%i-%s' % (os.getpid(), next(synchronize.SemLock._rand))
        return name

    # monkey patch the name creation for multiprocessing
    try:
        from multiprocessing import synchronize
        synchronize.SemLock._make_name = staticmethod(_make_name)
    except Exception as e:
        pass

__all__ = ["get_context"]
