#!/usr/bin/env python

# ...

from distutils.core import setup

setup(name='scikit-learn-aipy3',
      version='0.20.0',
      description='Machine Learning in QPython',
      author='Andreas Mueller',
      url='http://scikit-learn.org',
      packages=["sklearn", "sklearn.__check_build", "sklearn._build_utils", "sklearn.cluster", "sklearn.cluster.tests", "sklearn.compose", "sklearn.compose.tests", "sklearn.covariance", "sklearn.covariance.tests", "sklearn.cross_decomposition", "sklearn.cross_decomposition.tests", "sklearn.datasets", "sklearn.datasets.descr", "sklearn.datasets.tests", "sklearn.decomposition", "sklearn.decomposition.tests", "sklearn.ensemble", "sklearn.ensemble.tests", "sklearn.externals", "sklearn.externals.joblib", "sklearn.externals.joblib.externals", "sklearn.externals.joblib.externals.cloudpickle", "sklearn.externals.joblib.externals.loky", "sklearn.externals.joblib.externals.loky.backend", "sklearn.feature_extraction", "sklearn.feature_extraction.tests", "sklearn.feature_selection", "sklearn.feature_selection.tests", "sklearn.gaussian_process", "sklearn.gaussian_process.tests", "sklearn.linear_model", "sklearn.linear_model.tests", "sklearn.manifold", "sklearn.manifold.tests", "sklearn.metrics", "sklearn.metrics.cluster", "sklearn.metrics.cluster.tests", "sklearn.metrics.tests", "sklearn.mixture", "sklearn.mixture.tests", "sklearn.model_selection", "sklearn.model_selection.tests", "sklearn.neighbors", "sklearn.neighbors.tests", "sklearn.neural_network", "sklearn.neural_network.tests", "sklearn.preprocessing", "sklearn.preprocessing.tests", "sklearn.semi_supervised", "sklearn.semi_supervised.tests", "sklearn.svm", "sklearn.svm.tests", "sklearn.tests", "sklearn.tree", "sklearn.tree.tests", "sklearn.utils", "sklearn.utils.sparsetools", "sklearn.utils.sparsetools.tests", "sklearn.utils.tests"],
      package_data={
            "sklearn":[
"*.py",
"*.so",
"__check_build/*.py",
"__check_build/*.so",
"_build_utils/*.py",
"cluster/*.py",
"cluster/*.so",
"cluster/tests/*.py",
"covariance/*.py",
"covariance/tests/*.py",
"cross_decomposition/*.py",
"cross_decomposition/tests/*.py",
"datasets/*.py",
"datasets/*.so",
"datasets/data/*",
"datasets/descr/*",
"datasets/images/*",
"datasets/tests/*.py",
"datasets/tests/data/*.py",
"datasets/tests/data/*.txt",
"decomposition/*.py",
"decomposition/*.so",
"decomposition/tests/*.py",
"ensemble/*.py",
"ensemble/*.so",
"ensemble/tests/*.py",
"externals/*.py",
"externals/joblib/*.py",
"feature_extraction/*.py",
"feature_extraction/*.so",
"feature_extraction/tests/*.py",
"feature_selection/*.py",
"feature_selection/tests/*.py",
"gaussian_process/*.py",
"gaussian_process/tests/*.py",
"linear_model/*.py",
"linear_model/*.so",
"linear_model/tests/*.py",
"manifold/*.py",
"manifold/*.so",
"manifold/tests/*.py",
"metrics/*.py",
"metrics/*.so",
"metrics/cluster/*.py",
"metrics/cluster/*.so",
"metrics/cluster/tests/*.py",
"metrics/tests/*.py",
"mixture/*.py",
"mixture/tests/*.py",
"model_selection/*.py",
"model_selection/tests/*.py",
"neighbors/*.py",
"neighbors/*.so",
"neighbors/tests/*.py",
"neural_network/*.py",
"neural_network/tests/*.py",
"preprocessing/*.py",
"preprocessing/tests/*.py",
"semi_supervised/*.py",
"semi_supervised/tests/*.py",
"src/*.py",
"src/cblas/*.py",
"svm/*.py",
"svm/*.so",
"svm/src/*.py",
"svm/src/liblinear/*.py",
"svm/src/libsvm/*.py",
"svm/tests/*.py",
"tests/*.py",
"tree/*.py",
"tree/*.so",
"tree/tests/*.py",
"utils/*.py",
"utils/*.so",
"utils/sparsetools/*.py",
"utils/sparsetools/tests/*.py",
"utils/src/*.py",
"utils/tests/*.py",
]
      },
      long_description="""
Scikit-learn is a Python module for machine learning built on top of SciPy and distributed under the 3-Clause BSD license.

The project was started in 2007 by David Cournapeau as a Google Summer of Code project, and since then many volunteers have contributed. See the AUTHORS.rst file for a complete list of contributors.

It is currently maintained by a team of volunteers.

""",
      license="BSD",
      install_requires=["scipy-aipy3","numpy-aipy3"],
     )
