#!/usr/bin/env python

# ...

from distutils.core import setup
from distutils.util import convert_path
from fnmatch import fnmatchcase
import os

def find_packages(where='.', exclude=()):
    out = []
    stack = [(convert_path(where), '')]
    while stack:
        where, prefix = stack.pop(0)
        for name in os.listdir(where):
            fn = os.path.join(where, name)
            if ('.' not in name and os.path.isdir(fn) and
                    os.path.isfile(os.path.join(fn, '__init__.py'))):
                out.append(prefix + name)
                stack.append((fn, prefix + name + '.'))
    for pat in list(exclude) + ['ez_setup', 'distribute_setup']:
        out = [item for item in out if not fnmatchcase(item, pat)]
    return out



setup(name='theano-aipy3',
      version='1.0.3',
      description='Theano is a Python library that allows you to define, optimize, and efficiently evaluate mathematical expressions involving multi-dimensional arrays, this is the prebuilt version for QPython (AiPy branch)',
      author='LISA laboratory, University of Montreal',
      url='http://deeplearning.net/software/theano/',
      packages=find_packages(),
      package_data={
          '': ['*.txt', '*.rst', '*.cu', '*.cuh', '*.c', '*.sh', '*.pkl',
               '*.h', '*.cpp', 'ChangeLog', 'c_code/*'],
          'theano.misc': ['*.sh'],
          'theano.d3viz': ['html/*', 'css/*', 'js/*']
      },
      entry_points={
          'console_scripts': ['theano-cache = bin.theano_cache:main',
                              'theano-nose = bin.theano_nose:main']
      },

      long_description="""


Theano is a Python library that allows you to define, optimize, and efficiently evaluate mathematical expressions involving multi-dimensional arrays. It is built on top of NumPy. Theano features:

tight integration with NumPy: a similar interface to NumPy's. numpy.ndarrays are also used internally in Theano-compiled functions.
transparent use of a GPU: perform data-intensive computations up to 140x faster than on a CPU (support for float32 only).
efficient symbolic differentiation: Theano can compute derivatives for functions of one or many inputs.
speed and stability optimizations: avoid nasty bugs when computing expressions such as log(1 + exp(x)) for large values of x.
dynamic C code generation: evaluate expressions faster.
extensive unit-testing and self-verification: includes tools for detecting and diagnosing bugs and/or potential problems.
Theano has been powering large-scale computationally intensive scientific research since 2007, but it is also approachable enough to be used in the classroom (IFT6266 at the University of Montreal).

It lacks compile toolchain in qpython now, so it doesn't support execute optimized C-implementations right now, we will try to improve later.

""",
      license="BSD",
      install_requires=["nose","parameterized","scipy-aipy3"],
     )
