#!/usr/bin/env python

# ...

from distutils.core import setup
from setuptools import setup, Extension

setup(name='kiwisolver-qpython3',
      version='1.0.1',
      description='A fast implementation of the Cassowary constraint solver for QPYTHON',
      author='The Nucleic Development Team',
      author_email='sccolbert@gmail.com',
      url='https://github.com/nucleic/kiwi',
      packages=['kiwisolver',],
      package_data={
        'kiwisolver':[
            '*.py',
            '*.so'
        ]
},
      long_description="""

Kiwi is an efficient C++ implementation of the Cassowary constraint solving algorithm. Kiwi is an implementation of the algorithm based on the seminal Cassowary paper. It is not a refactoring of the original C++ solver. Kiwi has been designed from the ground up to be lightweight and fast. Kiwi ranges from 10x to 500x faster than the original Cassowary solver with typical use cases gaining a 40x improvement. Memory savings are consistently > 5x.

In addition to the C++ solver, Kiwi ships with hand-rolled Python bindings.


""",
      license="https://raw.githubusercontent.com/nucleic/kiwi/master/LICENSE",
     )
