#!/usr/bin/env python

# ...

from distutils.core import setup

setup(name='numpy-aipy3',
      version='1.14.3',
      description='The fundamental package needed for scientific computing with Python',
      author='Numpy team',
      author_email='numpy-discussion@python.org',
      url='http://www.numpy.org/',
      packages=["numpy"],
      package_data={
            "numpy": [
"compat/*.py",
"core/*.py",
"core/*.so",
"distutils/*.py",
"distutils/command/*.py",
"distutils/fcompiler/*.py",
"testing/nose_tools/*.py",
"doc/*.py",
"f2py/*.py",
"fft/*.py",
"fft/*.so",
"lib/*.py",
"linalg/*.py",
"linalg/*.so",
"ma/*.py",
"matrixlib/*.py",
"polynomial/*.py",
"random/*.py",
"random/*.so",
"testing/*.py",
            ]
      },
      long_description="""

NOTE: It is the Numpy-aipy for QPython3, to use it, you need to install QPY36 v1.2+ (which installs Python 3.6.6+) on your QPython or QPython3. And You can install QPY36 from http://qpy36.qpython.org, install AIPY from http://www.aipy.org.


NumPy is the fundamental package needed for scientific computing with Python. This package contains:

- a powerful N-dimensional array object
- sophisticated (broadcasting) functions
- basic linear algebra functions
- basic Fourier transforms
- sophisticated random number capabilities
- tools for integrating Fortran code
- tools for integrating C/C++ code

Besides its obvious scientific uses, NumPy can also be used as an efficient multi-dimensional container of generic data. Arbitrary data types can be defined. This allows NumPy to seamlessly and speedily integrate with a wide variety of databases.

NumPy is a successor for two earlier scientific Python libraries: NumPy derives from the old Numeric code base and can be used as a replacement for Numeric. It also adds the features introduced by Numarray and can also be used to replace Numarray.

""",
      license="http://www.numpy.org/license.html",
     )
